/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.client.screen.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.technicalitiesmc.lib.client.screen.widget.SimpleWidget;
import com.technicalitiesmc.lib.util.TooltipProvider;
import com.technicalitiesmc.lib.util.value.Reference;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.Range;

public class NumberSelectorWidget
extends SimpleWidget {
    private final Reference<Integer> value;
    private final Range<Integer> range;
    @Nullable
    private final TooltipProvider tooltipProvider;

    public NumberSelectorWidget(int x, int y, int width, int height, BooleanSupplier enabled, Reference<Integer> value, Range<Integer> range, @Nullable TooltipProvider tooltipProvider) {
        super(x, y, width, height, enabled);
        this.value = value;
        this.range = range;
        this.tooltipProvider = tooltipProvider;
    }

    @Override
    public void onClicked(double x, double y, int button) {
        if (button == 2) {
            Integer val = (Integer)this.value.get();
            if (val.intValue() == ((Integer)this.range.getMinimum()).intValue()) {
                this.value.set((Integer)this.range.getMaximum());
            } else {
                this.value.set((Integer)this.range.getMinimum());
            }
            this.playClickSound();
        }
    }

    @Override
    public boolean onMouseScrolled(double x, double y, double amount) {
        int direction = (int)Math.signum(amount);
        int scale = Screen.m_96638_() ? 8 : 1;
        this.value.set((Integer)this.range.fit((Object)((Integer)this.value.get() + direction * scale)));
        this.playClickSound(0.8f, 0.2f);
        return true;
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<Component> tooltip) {
        if (this.tooltipProvider != null) {
            this.tooltipProvider.addTooltip(tooltip);
        }
    }

    @Override
    public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        Font font = Minecraft.m_91087_().f_91062_;
        String number = ((Integer)this.value.get()).toString();
        int x = (this.size().x() - font.m_92895_(number)) / 2;
        int n = this.size().y();
        Objects.requireNonNull(font);
        int y = (n - 9) / 2 + 1;
        font.m_92883_(poseStack, number, (float)(x + 1), (float)(y + 1), -5329234);
        font.m_92883_(poseStack, number, (float)x, (float)y, -12698050);
    }
}

